"use strict";

var _require = require('mssql'),
  ConnectionPool = _require.ConnectionPool;
var pools = {};

// create a new connection pool
function CreatePool(config) {
  var key = JSON.stringify(config);
  if (GetPool(key)) throw new Error('Pool already exists');
  pools[key] = new ConnectionPool(config).connect();
  return pools[key];
}

// get a connection pool from all pools
function GetPool(name) {
  if (pools[name]) return pools[name];else return null;
}

// if pool already exists, return it, otherwise create it
function GetCreateIfNotExistPool(config) {
  var key = JSON.stringify(config);
  var pool = GetPool(key);
  if (pool) return pool;else return CreatePool(config);
}

// close a single pool
function ClosePool(config) {
  var key = JSON.stringify(config);
  if (pools[key]) {
    var pool = pools[key];
    delete pools[key];
    pool.close();
    return true;
  }
  return false;
}

// close all the pools
function CloseAllPools() {
  pools.forEach(function (pool) {
    pool.close();
  });
  pools = {};
  return true;
}
module.exports = {
  ClosePool: ClosePool,
  CloseAllPools: CloseAllPools,
  CreatePool: CreatePool,
  GetPool: GetPool,
  GetCreateIfNotExistPool: GetCreateIfNotExistPool
};