/*! @azure/msal-browser v2.32.1 2022-12-07 */
'use strict';
import { __extends, __assign } from '../_virtual/_tslib.js';
import { PerformanceClient } from '@azure/msal-common';
import { BrowserCrypto } from '../crypto/BrowserCrypto.js';
import { GuidGenerator } from '../crypto/GuidGenerator.js';
import { BrowserPerformanceMeasurement } from './BrowserPerformanceMeasurement.js';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var BrowserPerformanceClient = /** @class */ (function (_super) {
    __extends(BrowserPerformanceClient, _super);
    function BrowserPerformanceClient(clientId, authority, logger, libraryName, libraryVersion, applicationTelemetry, cryptoOptions) {
        var _this = _super.call(this, clientId, authority, logger, libraryName, libraryVersion, applicationTelemetry) || this;
        _this.browserCrypto = new BrowserCrypto(_this.logger, cryptoOptions);
        _this.guidGenerator = new GuidGenerator(_this.browserCrypto);
        return _this;
    }
    BrowserPerformanceClient.prototype.startPerformanceMeasuremeant = function (measureName, correlationId) {
        return new BrowserPerformanceMeasurement(measureName, correlationId);
    };
    BrowserPerformanceClient.prototype.generateId = function () {
        return this.guidGenerator.generateGuid();
    };
    BrowserPerformanceClient.prototype.getPageVisibility = function () {
        var _a;
        return ((_a = document.visibilityState) === null || _a === void 0 ? void 0 : _a.toString()) || null;
    };
    /**
     * Starts measuring performance for a given operation. Returns a function that should be used to end the measurement.
     * Also captures browser page visibilityState.
     *
     * @param {PerformanceEvents} measureName
     * @param {?string} [correlationId]
     * @returns {((event?: Partial<PerformanceEvent>) => PerformanceEvent| null)}
     */
    BrowserPerformanceClient.prototype.startMeasurement = function (measureName, correlationId) {
        var _this = this;
        // Capture page visibilityState and then invoke start/end measurement
        var startPageVisibility = this.getPageVisibility();
        var inProgressEvent = _super.prototype.startMeasurement.call(this, measureName, correlationId);
        return __assign(__assign({}, inProgressEvent), { endMeasurement: function (event) {
                return inProgressEvent.endMeasurement(__assign({ startPageVisibility: startPageVisibility, endPageVisibility: _this.getPageVisibility() }, event));
            } });
    };
    return BrowserPerformanceClient;
}(PerformanceClient));

export { BrowserPerformanceClient };
//# sourceMappingURL=BrowserPerformanceClient.js.map
