"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorParser = errorParser;
exports.infoParser = infoParser;

var _token = require("./token");

function parseToken(parser, options, callback) {
  // length
  parser.readUInt16LE(() => {
    parser.readUInt32LE(number => {
      parser.readUInt8(state => {
        parser.readUInt8(clazz => {
          parser.readUsVarChar(message => {
            parser.readBVarChar(serverName => {
              parser.readBVarChar(procName => {
                (options.tdsVersion < '7_2' ? parser.readUInt16LE : parser.readUInt32LE).call(parser, lineNumber => {
                  callback({
                    'number': number,
                    'state': state,
                    'class': clazz,
                    'message': message,
                    'serverName': serverName,
                    'procName': procName,
                    'lineNumber': lineNumber
                  });
                });
              });
            });
          });
        });
      });
    });
  });
}

function infoParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.InfoMessageToken(data));
  });
}

function errorParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.ErrorMessageToken(data));
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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