"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const NULL_LENGTH = Buffer.from([0xFF, 0xFF]);
const NChar = {
  id: 0xEF,
  type: 'NCHAR',
  name: 'NChar',
  maximumLength: 4000,
  declaration: function (parameter) {
    // const value = parameter.value as null | string | { toString(): string };
    const value = parameter.value; // Temporary solution. Remove 'any' later.

    let length;

    if (parameter.length) {
      length = parameter.length;
    } else if (parameter.value != null) {
      length = value.toString().length || 1;
    } else if (parameter.value === null && !parameter.output) {
      length = 1;
    } else {
      length = this.maximumLength;
    }

    if (length < this.maximumLength) {
      return 'nchar(' + length + ')';
    } else {
      return 'nchar(' + this.maximumLength + ')';
    }
  },
  resolveLength: function (parameter) {
    // const value = parameter.value as null | string | { toString(): string };
    const value = parameter.value; // Temporary solution. Remove 'any' later.

    if (parameter.length != null) {
      return parameter.length;
    } else if (parameter.value != null) {
      if (Buffer.isBuffer(parameter.value)) {
        return parameter.value.length / 2 || 1;
      } else {
        return value.toString().length || 1;
      }
    } else {
      return this.maximumLength;
    }
  },
  generateTypeInfo: function (parameter) {
    const buffer = Buffer.alloc(8);
    buffer.writeUInt8(this.id, 0);
    buffer.writeUInt16LE(parameter.length * 2, 1);

    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 3, 0, 5);
    }

    return buffer;
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const {
      value
    } = parameter;

    if (value instanceof Buffer) {
      const length = value.length;
      const buffer = Buffer.alloc(2);
      buffer.writeUInt16LE(length, 0);
      return buffer;
    } else {
      const length = Buffer.byteLength(value.toString(), 'ucs2');
      const buffer = Buffer.alloc(2);
      buffer.writeUInt16LE(length, 0);
      return buffer;
    }
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const value = parameter.value;

    if (value instanceof Buffer) {
      yield value;
    } else {
      yield Buffer.from(value, 'ucs2');
    }
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }

    return value;
  }
};
var _default = NChar;
exports.default = _default;
module.exports = NChar;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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