"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _writableTrackingBuffer = _interopRequireDefault(require("./tracking-buffer/writable-tracking-buffer"));

var _allHeaders = require("./all-headers");

let _Symbol$iterator;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// const OPTION = {
//   WITH_RECOMPILE: 0x01,
//   NO_METADATA: 0x02,
//   REUSE_METADATA: 0x04
// };
const STATUS = {
  BY_REF_VALUE: 0x01,
  DEFAULT_VALUE: 0x02
};
/*
  s2.2.6.5
 */

_Symbol$iterator = Symbol.iterator;

class RpcRequestPayload {
  constructor(procedure, parameters, txnDescriptor, options, collation) {
    this.procedure = void 0;
    this.parameters = void 0;
    this.options = void 0;
    this.txnDescriptor = void 0;
    this.collation = void 0;
    this.procedure = procedure;
    this.parameters = parameters;
    this.options = options;
    this.txnDescriptor = txnDescriptor;
    this.collation = collation;
  }

  [_Symbol$iterator]() {
    return this.generateData();
  }

  *generateData() {
    const buffer = new _writableTrackingBuffer.default(500);

    if (this.options.tdsVersion >= '7_2') {
      const outstandingRequestCount = 1;
      (0, _allHeaders.writeToTrackingBuffer)(buffer, this.txnDescriptor, outstandingRequestCount);
    }

    if (typeof this.procedure === 'string') {
      buffer.writeUsVarchar(this.procedure);
    } else {
      buffer.writeUShort(0xFFFF);
      buffer.writeUShort(this.procedure);
    }

    const optionFlags = 0;
    buffer.writeUInt16LE(optionFlags);
    yield buffer.data;
    const parametersLength = this.parameters.length;

    for (let i = 0; i < parametersLength; i++) {
      yield* this.generateParameterData(this.parameters[i]);
    }
  }

  toString(indent = '') {
    return indent + ('RPC Request - ' + this.procedure);
  }

  *generateParameterData(parameter) {
    const buffer = new _writableTrackingBuffer.default(1 + 2 + Buffer.byteLength(parameter.name, 'ucs-2') + 1);
    buffer.writeBVarchar('@' + parameter.name);
    let statusFlags = 0;

    if (parameter.output) {
      statusFlags |= STATUS.BY_REF_VALUE;
    }

    buffer.writeUInt8(statusFlags);
    yield buffer.data;
    const param = {
      value: parameter.value
    };
    const type = parameter.type;

    if ((type.id & 0x30) === 0x20) {
      if (parameter.length) {
        param.length = parameter.length;
      } else if (type.resolveLength) {
        param.length = type.resolveLength(parameter);
      }
    }

    if (parameter.precision) {
      param.precision = parameter.precision;
    } else if (type.resolvePrecision) {
      param.precision = type.resolvePrecision(parameter);
    }

    if (parameter.scale) {
      param.scale = parameter.scale;
    } else if (type.resolveScale) {
      param.scale = type.resolveScale(parameter);
    }

    if (this.collation) {
      param.collation = this.collation;
    }

    yield type.generateTypeInfo(param, this.options);
    yield type.generateParameterLength(param, this.options);
    yield* type.generateParameterData(param, this.options);
  }

}

var _default = RpcRequestPayload;
exports.default = _default;
module.exports = RpcRequestPayload;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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