/*! @azure/msal-browser v2.32.1 2022-12-07 */
'use strict';
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var BrowserPerformanceMeasurement = /** @class */ (function () {
    function BrowserPerformanceMeasurement(name, correlationId) {
        this.correlationId = correlationId;
        this.measureName = "msal.measure." + name + "." + this.correlationId;
        this.startMark = "msal.start." + name + "." + this.correlationId;
        this.endMark = "msal.end." + name + "." + this.correlationId;
    }
    BrowserPerformanceMeasurement.supportsBrowserPerformance = function () {
        return typeof window !== "undefined" &&
            typeof window.performance !== "undefined" &&
            typeof window.performance.mark === "function" &&
            typeof window.performance.measure === "function" &&
            typeof window.performance.clearMarks === "function" &&
            typeof window.performance.clearMeasures === "function" &&
            typeof window.performance.getEntriesByName === "function";
    };
    BrowserPerformanceMeasurement.prototype.startMeasurement = function () {
        if (BrowserPerformanceMeasurement.supportsBrowserPerformance()) {
            try {
                window.performance.mark(this.startMark);
            }
            catch (e) {
                // Silently catch
            }
        }
    };
    BrowserPerformanceMeasurement.prototype.endMeasurement = function () {
        if (BrowserPerformanceMeasurement.supportsBrowserPerformance()) {
            try {
                window.performance.mark(this.endMark);
                window.performance.measure(this.measureName, this.startMark, this.endMark);
            }
            catch (e) {
                // Silently catch
            }
        }
    };
    BrowserPerformanceMeasurement.prototype.flushMeasurement = function () {
        if (BrowserPerformanceMeasurement.supportsBrowserPerformance()) {
            try {
                var entriesForMeasurement = window.performance.getEntriesByName(this.measureName, "measure");
                if (entriesForMeasurement.length > 0) {
                    var durationMs = entriesForMeasurement[0].duration;
                    window.performance.clearMeasures(this.measureName);
                    window.performance.clearMarks(this.startMark);
                    window.performance.clearMarks(this.endMark);
                    return durationMs;
                }
            }
            catch (e) {
                // Silently catch and return null
            }
        }
        return null;
    };
    return BrowserPerformanceMeasurement;
}());

export { BrowserPerformanceMeasurement };
//# sourceMappingURL=BrowserPerformanceMeasurement.js.map
